
import { Link } from 'react-router-dom';
import { Zap, Twitter, Github, Linkedin, Mail } from 'lucide-react';

export function Footer() {
  return (
    <footer className="bg-black border-t border-gray-800">
      <div className="container mx-auto px-4 py-12">
        <div className="grid grid-cols-1 md:grid-cols-4 gap-8">
          {/* Brand */}
          <div className="space-y-4">
            <Link to="/" className="flex items-center space-x-2">
              <Zap className="h-8 w-8 text-purple-500" />
              <span className="text-xl font-bold bg-gradient-to-r from-purple-400 to-blue-400 bg-clip-text text-transparent">
                Jarvis
              </span>
            </Link>
            <p className="text-gray-400 text-sm">
              Empowering businesses with AI automation solutions that transform workflows and boost productivity.
            </p>
            <div className="flex space-x-4">
              <a href="#" className="text-gray-400 hover:text-purple-400 transition-colors">
                <Twitter className="h-5 w-5" />
              </a>
              <a href="#" className="text-gray-400 hover:text-purple-400 transition-colors">
                <Github className="h-5 w-5" />
              </a>
              <a href="#" className="text-gray-400 hover:text-purple-400 transition-colors">
                <Linkedin className="h-5 w-5" />
              </a>
              <a href="#" className="text-gray-400 hover:text-purple-400 transition-colors">
                <Mail className="h-5 w-5" />
              </a>
            </div>
          </div>

          {/* Services */}
          <div className="space-y-4">
            <h3 className="text-white font-semibold">Services</h3>
            <div className="space-y-2">
              <Link to="/gigs" className="block text-gray-400 hover:text-purple-400 transition-colors text-sm">
                AI Automation
              </Link>
              <Link to="/gigs" className="block text-gray-400 hover:text-purple-400 transition-colors text-sm">
                Workflow Integration
              </Link>
              <Link to="/gigs" className="block text-gray-400 hover:text-purple-400 transition-colors text-sm">
                Data Processing
              </Link>
              <Link to="/gigs" className="block text-gray-400 hover:text-purple-400 transition-colors text-sm">
                Custom Solutions
              </Link>
            </div>
          </div>

          {/* Company */}
          <div className="space-y-4">
            <h3 className="text-white font-semibold">Company</h3>
            <div className="space-y-2">
              <Link to="#" className="block text-gray-400 hover:text-purple-400 transition-colors text-sm">
                About Us
              </Link>
              <Link to="#" className="block text-gray-400 hover:text-purple-400 transition-colors text-sm">
                Careers
              </Link>
              <Link to="#" className="block text-gray-400 hover:text-purple-400 transition-colors text-sm">
                Blog
              </Link>
              <Link to="#" className="block text-gray-400 hover:text-purple-400 transition-colors text-sm">
                Contact
              </Link>
            </div>
          </div>

          {/* Legal */}
          <div className="space-y-4">
            <h3 className="text-white font-semibold">Legal</h3>
            <div className="space-y-2">
              <Link to="#" className="block text-gray-400 hover:text-purple-400 transition-colors text-sm">
                Privacy Policy
              </Link>
              <Link to="#" className="block text-gray-400 hover:text-purple-400 transition-colors text-sm">
                Terms of Service
              </Link>
              <Link to="#" className="block text-gray-400 hover:text-purple-400 transition-colors text-sm">
                Cookie Policy
              </Link>
              <Link to="#" className="block text-gray-400 hover:text-purple-400 transition-colors text-sm">
                GDPR
              </Link>
            </div>
          </div>
        </div>

        <div className="border-t border-gray-800 mt-12 pt-8">
          <div className="flex flex-col md:flex-row justify-between items-center">
            <p className="text-gray-400 text-sm">
              © 2024 Jarvis. All rights reserved.
            </p>
            <p className="text-gray-400 text-sm mt-4 md:mt-0">
              Built with ❤️ for the future of work
            </p>
          </div>
        </div>
      </div>
    </footer>
  );
}
